﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace MicroRWD.UI.MFIC
{
    public partial class ComPortForm : Form
    {
        public string PortName { get; private set;  }

        public ComPortForm(string portName)
        {
            InitializeComponent();

            PortName = portName;
        }

        private void ComPortForm_Load(object sender, EventArgs e)
        {
            if (!DesignMode && (Program.Controller != null))
            {
                // Interrogate serial port layer for valid COM ports
                List<string> portNames = new List<string>(SerialPort.GetPortNames());

                // If at least one port is present
                if (portNames.Count > 0)
                {
                    // Sort port names
                    portNames.Sort();

                    // Load combo box with the valid port names
                    foreach (string portName in portNames)
                    {
                        comPortComboBox.Items.Add(portName);
                    }

                    // Initialise selected item
                    if (portNames.Contains(PortName))
                    {
                        // Default to current item
                        comPortComboBox.SelectedItem = PortName;
                    }
                    else
                    {
                        // Default to first item
                        comPortComboBox.SelectedItem = comPortComboBox.Items[0];
                    }
                }
            }
        }

        private void okButton_Click(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty((string)comPortComboBox.SelectedItem))            
            {
                // Update property
                PortName = (string)comPortComboBox.SelectedItem;

                // Close the dialog
                Close();
            }
        }
    }
}
